#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import sys
import time
import os
import datetime
import epgdb
import configreader
import checker
import tv2avi
import recdb
import chdb
import status
import re
recpath=configreader.getpath('recpath')
path=str(os.path.dirname(os.path.abspath(__file__)))+"/"
def task():
    """
    数分毎に実行されるタスク処理
    予定によって子プロセスを生成し処理する。
    """
    recdb.delete_old("6")
    tasks=recdb.getnow("2")
    #print tasks
    inum=recdb.countRecNow("1")
    print "now-rectask"
    print "inum:"+str(inum)+"bscsrec:"+str(status.getBSCSRecording())+"terec:"+str(status.getTERecording())+" epg:"+str(status.getEPGUpdating())
    if inum+status.getBSCSRecording()+status.getTERecording() < 2:
        update=chdb.update()
        #print "番組表更新処理"
        
        if len(update)>0 and status.getEPGUpdating()==0:
            status.setEPGUpdating(1)
            print "番組表を更新"
            print update
            status.setEPGUpdating(1)
            pid=os.fork()
            if pid!=0:#親プロセスの場合
                ""
            else:#子プロセスの場合　アップデートを行って終了
                i=0
                for bctype in update:
                    time.sleep(1)
                    print bctype
                    epgdb.updatebc(bctype)
                    update=chdb.update()
                    i=i+1
                    print update
                    if i>10:
                        break
                status.setEPGUpdating(0)
                sys.exit()
    for task in tasks:
        #print task
        try:
            chtxt=task['chtxt']
        except:
            chtxt=""
        try:
            title=task['title']
        except:
            title=""
        try:
            btime=task['btime']
            bt=datetime.datetime.strptime(btime,"%Y-%m-%d %H:%M:%S")
        except:
            btime=""
            bt=datetime.datetime.strptime("2009-01-01 00:00:00","%Y-%m-%d %H:%M:%S")
        try:
            etime=task['etime']
            et=datetime.datetime.strptime(etime,"%Y-%m-%d %H:%M:%S")
        except:
            etime=""
            et=datetime.datetime.strptime("2009-01-01 00:00:00","%Y-%m-%d %H:%M:%S")
        try:
            opt=task['opt']
        except:
            opt=""
        tnow=datetime.datetime.now()
        dtt=bt-tnow
        dt=dtt.days*24*60*60+dtt.seconds
        
        if task["type"]==recdb.REC_RESERVE:#"res,"+chtxt+","+title+","+btime+","+etime+","+opt
            isUpdate=0
            print dt
            if (dt<58*60 and dt>20*60):
                pid=os.fork()
                if pid!=0:#親プロセスの場合
                    ""
                else:#子プロセスの場合　アップデートを行って終了
                    cht=chdb.chtxtsearch(chtxt)['bctype']
                    if cht.find('te')!=-1:
                        cht='te'
                    else:
                        cht='bscs'
                    if cht=='bscs':
                        gettaskbscs=recdb.countRecNow_minutes_BSCS("10")
                        getnowbscs=status.getBSCSRecording()
                        bscs=getnowbscs+gettaskbscs
                        if bscs <2 and status.getEPGUpdating()!=1:
                            print "now(bscs):"+str(getnowbscs)+" task(bscs):"+str(gettaskbscs)
                            status.setEPGUpdating(1)
                            epgdb.updatebc(chdb.chtxtsearch(chtxt)['bctype'])
                            time.sleep(10)
                            isUpdate=1
                            status.setEPGUpdating(0)
                        else:
                            isUpdate=0
                    if cht=="te":
                        gettaskte=recdb.countRecNow_minutes_TE("10")
                        getnowte=status.getTERecording()
                        te=getnowte+gettaskte
                        if te <2 and status.getEPGUpdating()!=1:
                            print "now(te):"+str(getnowte)+" task(te):"+str(gettaskte)
                            status.setEPGUpdating(1)
                            epgdb.updatebc(chdb.chtxtsearch(chtxt)['bctype'])
                            time.sleep(10)
                            status.setEPGUpdating(0)
                            isUpdate=1
                        else:
                            isUpdate=0
                    if isUpdate:
                        recdata=epgdb.searchtime2(title.decode('utf-8'),btime,"5",chtxt)
                        chtxtn=recdata[0]
                        titlen=recdata[1]
                        btimen=recdata[2]
                        etimen=recdata[3]
                        bt=datetime.datetime.strptime(btimen,"%Y-%m-%d %H:%M:%S")
                        et=datetime.datetime.strptime(etimen,"%Y-%m-%d %H:%M:%S")
                        btimen=bt.strftime("%Y-%m-%d %H:%M:%S")
                        etimen=et.strftime("%Y-%m-%d %H:%M:%S")
                        if chtxt!="":
                            try:
                                recdb.del_reckey(recdb.REC_RESERVE, title, chtxt, btime)
                                recdb.rec_reckey(recdb.REC_FINAL_RESERVE, titlen, chtxtn, btimen, etimen, opt)
                            except Exception,inst:
                                print type(inst)
                                print inst
                        else:
                            print "nothing match"
                    else:
                        ""
                    sys.exit()
            elif dt<=10*60:
                try:
                    recdb.del_reckey(recdb.REC_RESERVE, title, chtxt, btime)
                    recdb.rec_reckey(recdb.REC_FINAL_RESERVE, title, chtxt, btime, etime, opt)
                except Exception,inst:
                    print type(inst)
                    print inst
        elif task["type"]==recdb.REC_KEYWORD:#"key,"+chtxt+","+keyword+","+btime+","+deltatime+","+opt
            deltatime=task['deltatime']
            if dt<90*60:
                recdata=epgdb.searchtime2(title.decode('utf-8'),btime,deltatime,chtxt)
                if recdata[1]!="":
                    chtxtt=recdata[0]
                    titlet=recdata[1]
                    btimet=recdata[2]
                    etimet=recdata[3]
                    bt=datetime.datetime.strptime(btimet,"%Y-%m-%d %H:%M:%S")
                    et=datetime.datetime.strptime(etimet,"%Y-%m-%d %H:%M:%S")
                    btimet=bt.strftime("%Y-%m-%d %H:%M:%S")
                    etimet=et.strftime("%Y-%m-%d %H:%M:%S")
                    try:
                        recdb.del_reckey(recdb.REC_KEYWORD, title, chtxt, btime)
                        recdb.rec_reckey(recdb.REC_RESERVE, titlet, chtxtt, btimet, etimet, opt)
                    except Exception,inst:
                        print type(inst)
                        print inst
                else:
                    print "nothing match"
        elif task["type"]==recdb.REC_KEYWORD_EVERY_SOME_DAYS:#"keyevery,"+chtxt+","+keyword+","+btime+","+deltatime+","+opt+","+deltaday
            deltatime=task['deltatime']
            deltaday=task['deltaday']
            dd=datetime.timedelta(days=int(deltaday))
            if dtt.days<0:
                recdb.del_reckey(recdb.REC_KEYWORD_EVERY_SOME_DAYS, title, chtxt, btime)
                bt=bt+dd
                et=et+dd
                btxt=bt.strftime("%Y-%m-%d %H:%M:%S")
                etxt=et.strftime("%Y-%m-%d %H:%M:%S")
                recdb.everyreserv(title,chtxt,btxt,etxt,deltatime,opt,deltaday)
            elif dt<120*60:
                recdb.keyreserv(title,chtxt,btime,etime,deltatime,opt)
                recdb.del_reckey(recdb.REC_KEYWORD_EVERY_SOME_DAYS, title, chtxt, btime)
                bt=bt+dd
                et=et+dd
                btxt=bt.strftime("%Y-%m-%d %H:%M:%S")
                etxt=et.strftime("%Y-%m-%d %H:%M:%S")
                recdb.everyreserv(title,chtxt,btxt,etxt,deltatime,opt,deltaday)
            
        elif task["type"]==recdb.REC_FINAL_RESERVE:#"rec,"+chtxt+","+title+","+btime+","+etime+","+opt
            print dt
            if dt<6*60 and dt>0:
                recdb.del_reckey(recdb.REC_FINAL_RESERVE, title, chtxt, btime)
                recdb.rec_reckey(recdb.REC_TS_RECORDING, title, chtxt, btime, etime, opt)
                print "録画開始"
                pid=os.fork()
                if pid!=0:#親プロセスの場合
                    ""
                else:
                    #print title
                    tv2avi.timetv2b25(recpath+"/"+title+".avi", chtxt, btime, etime, opt)
                    recdb.del_reckey(recdb.REC_TS_RECORDING, title, chtxt, btime)
                    tnow=datetime.datetime.now()
                    bt=datetime.datetime.strptime(btime,"%Y-%m-%d %H:%M:%S")
                    et=datetime.datetime.strptime(etime,"%Y-%m-%d %H:%M:%S")
                    dt=tnow-bt
                    bt=tnow+datetime.timedelta(seconds=600)
                    et=et+dt+datetime.timedelta(seconds=600)
                    btime=bt.strftime("%Y-%m-%d %H:%M:%S")
                    etime=et.strftime("%Y-%m-%d %H:%M:%S")
                    recdb.rec_reckey(recdb.REC_TS_DECODE_QUE,title,chtxt,btime,etime,opt)
                    sys.exit()
        elif task["type"]==recdb.REC_TS_DECODE_QUE:
            if dt<10*60:
                if status.getB25Decoding()<2:
                    pid=os.fork()
                    if pid!=0:#親プロセスの場合
                            ""
                    else:
                        pin=recpath+"/"+title
                        recdb.del_reckey(recdb.REC_TS_DECODE_QUE,title,chtxt,btime)
                        recdb.rec_reckey(recdb.REC_TS_DECODING, title, chtxt, btime, etime, opt)
                        tv2avi.b252ts(pin, chtxt, btime, etime, opt)
                        recdb.del_reckey(recdb.REC_TS_DECODING,title,chtxt,btime)
                        if not os.access(recpath+"/"+title+".ts", os.F_OK):
                            recdb.del_reckey(recdb.REC_TS_DECODING, title, chtxt, btime)
                            recdb.rec_reckey(recdb.REC_MISS_DECODE, title, chtxt, btime, etime, opt)
                        tnow=datetime.datetime.now()
                        bt=datetime.datetime.strptime(btime,"%Y-%m-%d %H:%M:%S")
                        et=datetime.datetime.strptime(etime,"%Y-%m-%d %H:%M:%S")
                        dt=tnow-bt
                        bt=tnow+datetime.timedelta(seconds=600)
                        et=et+dt+datetime.timedelta(seconds=600)
                        btime=bt.strftime("%Y-%m-%d %H:%M:%S")
                        etime=et.strftime("%Y-%m-%d %H:%M:%S")
                        recdb.rec_reckey(recdb.REC_ENCODE_QUE, title, chtxt, btime, etime, opt)
                        print "b25check "+recpath+"/"+title+".ts.b25 "+recpath+"/"+title+".ts"
                        print checker.checkB25Decode(recpath+"/"+title+".ts.b25",recpath+"/"+title+".ts")
                        if checker.checkB25Decode(recpath+"/"+title+".ts.b25",recpath+"/"+title+".ts")==1:
                            os.remove(recpath+"/"+title+".ts.b25")
                        sys.exit()
                else:
                    recdb.del_reckey(recdb.REC_TS_DECODE_QUE,title,chtxt,btime)
                    bt=bt+datetime.timedelta(seconds=600)
                    et=et+datetime.timedelta(seconds=600)
                    btime=bt.strftime("%Y-%m-%d %H:%M:%S")
                    etime=et.strftime("%Y-%m-%d %H:%M:%S")
                    recdb.rec_reckey(recdb.REC_TS_DECODE_QUE,title,chtxt,btime,etime,opt)
        elif task["type"]==recdb.REC_ENCODE_QUE:
            if dt<10*60:
                if status.getEncoding()<int(configreader.getenv("enc_max")):
                    pid=os.fork()
                    if pid>0:#親プロセスの場合
                            ""
                    else:
                        pin=recpath+"/"+title+".ts"
                        if re.search("d",opt):
                            pin=recpath+"/"+title+"sa.avi"
                        if re.search("5",opt):
                            pin=recpath+"/"+title+"sa.avi"
                        pout=recpath+"/"+title+".avi"
                        print [pin,pout,opt]
                        #print pin+":"+pout+":"+opt
                        recdb.del_reckey(recdb.REC_ENCODE_QUE,title,chtxt,btime)
                        recdb.rec_reckey(recdb.REC_ENCODE_LOCAL, title, chtxt, btime, etime, opt)
                        tv2avi.ts2avi(pin, pout, opt)
                        recdb.del_reckey(recdb.REC_ENCODE_LOCAL,title,chtxt,btime)
                        recdb.rec_reckey(recdb.REC_FIN_LOCAL, title, chtxt, btime, etime, opt)
                        sys.exit()
                else:
                    recdb.del_reckey(recdb.REC_ENCODE_QUE,title,chtxt,btime)
                    bt=bt+datetime.timedelta(seconds=600)
                    et=et+datetime.timedelta(seconds=600)
                    btime=bt.strftime("%Y-%m-%d %H:%M:%S")
                    etime=et.strftime("%Y-%m-%d %H:%M:%S")
                    recdb.rec_reckey(recdb.REC_ENCODE_QUE,title,chtxt,btime,etime,opt)